<?php
// Disable error reporting to prevent any PHP errors from being output
error_reporting(0);
ini_set('display_errors', 0);

// Start output buffering
ob_start();

// Set JSON header
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Accept');

// Start session without output
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include required files
require_once '../config/db.php';
require_once '../auth/auth.php';

// Function to send JSON response
function sendJsonResponse($success, $message, $code = 200) {
    ob_end_clean(); // Clear any output
    http_response_code($code);
    echo json_encode(['success' => $success, 'message' => $message]);
    exit;
}

// Check if user has permission to manage settings
if (!hasPermission('manage_settings')) {
    sendJsonResponse(false, 'Permission denied', 403);
}

// Get JSON data from request
$input = file_get_contents('php://input');
if (empty($input)) {
    sendJsonResponse(false, 'No data received', 400);
}

$data = json_decode($input, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    sendJsonResponse(false, 'Invalid JSON data: ' . json_last_error_msg(), 400);
}

if (!isset($data['status']) || !in_array($data['status'], ['open', 'closed'])) {
    sendJsonResponse(false, 'Invalid status value', 400);
}

try {
    // Update drawer status in database
    $stmt = $pdo->prepare("INSERT INTO store_settings (setting_key, setting_value, setting_group) 
                          VALUES ('drawer_status', ?, 'payment_settings') 
                          ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
    
    if ($stmt->execute([$data['status']])) {
        // Log the action
        logSystemAction('drawer_status_updated', "Cash drawer status changed to: {$data['status']}");
        sendJsonResponse(true, 'Drawer status updated successfully');
    } else {
        throw new Exception('Failed to update drawer status');
    }
} catch (Exception $e) {
    error_log("Error updating drawer status: " . $e->getMessage());
    sendJsonResponse(false, 'Error updating drawer status: ' . $e->getMessage(), 500);
} 